/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.relocations.org.mariadb.jdbc.client.column;

import java.sql.Date;
import java.sql.SQLDataException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.util.Calendar;
import java.util.TimeZone;
import net.impactdev.impactor.relocations.org.mariadb.jdbc.Configuration;
import net.impactdev.impactor.relocations.org.mariadb.jdbc.client.ColumnDecoder;
import net.impactdev.impactor.relocations.org.mariadb.jdbc.client.DataType;
import net.impactdev.impactor.relocations.org.mariadb.jdbc.client.ReadableByteBuf;
import net.impactdev.impactor.relocations.org.mariadb.jdbc.message.server.ColumnDefinitionPacket;

public class DateColumn
extends ColumnDefinitionPacket
implements ColumnDecoder {
    public DateColumn(ReadableByteBuf buf, int charset, long length, DataType dataType, byte decimals, int flags, int[] stringPos, String extTypeName, String extTypeFormat) {
        super(buf, charset, length, dataType, decimals, flags, stringPos, extTypeName, extTypeFormat);
    }

    @Override
    public String defaultClassname(Configuration conf) {
        return Date.class.getName();
    }

    @Override
    public int getColumnType(Configuration conf) {
        return 91;
    }

    @Override
    public String getColumnTypeName(Configuration conf) {
        return "DATE";
    }

    @Override
    public Object getDefaultText(Configuration conf, ReadableByteBuf buf, int length) throws SQLDataException {
        return this.decodeDateText(buf, length, null);
    }

    @Override
    public Object getDefaultBinary(Configuration conf, ReadableByteBuf buf, int length) throws SQLDataException {
        return this.decodeDateBinary(buf, length, null);
    }

    @Override
    public boolean decodeBooleanText(ReadableByteBuf buf, int length) throws SQLDataException {
        buf.skip(length);
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Boolean", new Object[]{this.dataType}));
    }

    @Override
    public boolean decodeBooleanBinary(ReadableByteBuf buf, int length) throws SQLDataException {
        buf.skip(length);
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Boolean", new Object[]{this.dataType}));
    }

    @Override
    public byte decodeByteText(ReadableByteBuf buf, int length) throws SQLDataException {
        buf.skip(length);
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Byte", new Object[]{this.dataType}));
    }

    @Override
    public byte decodeByteBinary(ReadableByteBuf buf, int length) throws SQLDataException {
        buf.skip(length);
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Byte", new Object[]{this.dataType}));
    }

    @Override
    public String decodeStringText(ReadableByteBuf buf, int length, Calendar cal) throws SQLDataException {
        return buf.readString(length);
    }

    @Override
    public String decodeStringBinary(ReadableByteBuf buf, int length, Calendar cal) throws SQLDataException {
        if (length == 0) {
            return "0000-00-00";
        }
        int dateYear = buf.readUnsignedShort();
        byte dateMonth = buf.readByte();
        byte dateDay = buf.readByte();
        return LocalDate.of(dateYear, dateMonth, (int)dateDay).toString();
    }

    @Override
    public short decodeShortText(ReadableByteBuf buf, int length) throws SQLDataException {
        buf.skip(length);
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Short", new Object[]{this.dataType}));
    }

    @Override
    public short decodeShortBinary(ReadableByteBuf buf, int length) throws SQLDataException {
        buf.skip(length);
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Short", new Object[]{this.dataType}));
    }

    @Override
    public int decodeIntText(ReadableByteBuf buf, int length) throws SQLDataException {
        buf.skip(length);
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Integer", new Object[]{this.dataType}));
    }

    @Override
    public int decodeIntBinary(ReadableByteBuf buf, int length) throws SQLDataException {
        buf.skip(length);
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Integer", new Object[]{this.dataType}));
    }

    @Override
    public long decodeLongText(ReadableByteBuf buf, int length) throws SQLDataException {
        buf.skip(length);
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Long", new Object[]{this.dataType}));
    }

    @Override
    public long decodeLongBinary(ReadableByteBuf buf, int length) throws SQLDataException {
        buf.skip(length);
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Long", new Object[]{this.dataType}));
    }

    @Override
    public float decodeFloatText(ReadableByteBuf buf, int length) throws SQLDataException {
        buf.skip(length);
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Float", new Object[]{this.dataType}));
    }

    @Override
    public float decodeFloatBinary(ReadableByteBuf buf, int length) throws SQLDataException {
        buf.skip(length);
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Float", new Object[]{this.dataType}));
    }

    @Override
    public double decodeDoubleText(ReadableByteBuf buf, int length) throws SQLDataException {
        buf.skip(length);
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Double", new Object[]{this.dataType}));
    }

    @Override
    public double decodeDoubleBinary(ReadableByteBuf buf, int length) throws SQLDataException {
        buf.skip(length);
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Double", new Object[]{this.dataType}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date decodeDateText(ReadableByteBuf buf, int length, Calendar cal) throws SQLDataException {
        Calendar c;
        int year = (int)buf.atoull(4);
        buf.skip(1);
        int month = (int)buf.atoull(2);
        buf.skip(1);
        int dayOfMonth = (int)buf.atoull(2);
        if (year == 0 && month == 0 && dayOfMonth == 0) {
            return null;
        }
        Calendar calendar = c = cal == null ? Calendar.getInstance() : cal;
        synchronized (calendar) {
            c.clear();
            c.set(1, year);
            c.set(2, month - 1);
            c.set(5, dayOfMonth);
            return new Date(c.getTimeInMillis());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date decodeDateBinary(ReadableByteBuf buf, int length, Calendar cal) throws SQLDataException {
        Calendar c;
        if (length == 0) {
            return null;
        }
        Calendar calendar = c = cal == null ? Calendar.getInstance() : cal;
        synchronized (calendar) {
            c.clear();
            c.set(1, buf.readShort());
            c.set(2, buf.readByte() - 1);
            c.set(5, buf.readByte());
            return new Date(c.getTimeInMillis());
        }
    }

    @Override
    public Time decodeTimeText(ReadableByteBuf buf, int length, Calendar cal) throws SQLDataException {
        buf.skip(length);
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Time", new Object[]{this.dataType}));
    }

    @Override
    public Time decodeTimeBinary(ReadableByteBuf buf, int length, Calendar cal) throws SQLDataException {
        buf.skip(length);
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Time", new Object[]{this.dataType}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Timestamp decodeTimestampText(ReadableByteBuf buf, int length, Calendar calParam) throws SQLDataException {
        if (calParam == null || calParam.getTimeZone().equals(TimeZone.getDefault())) {
            String s = buf.readAscii(length);
            if ("0000-00-00".equals(s)) {
                return null;
            }
            return new Timestamp(Date.valueOf(s).getTime());
        }
        String[] datePart = buf.readAscii(length).split("-");
        Calendar calendar = calParam;
        synchronized (calendar) {
            calParam.clear();
            calParam.set(Integer.parseInt(datePart[0]), Integer.parseInt(datePart[1]) - 1, Integer.parseInt(datePart[2]));
            return new Timestamp(calParam.getTimeInMillis());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Timestamp decodeTimestampBinary(ReadableByteBuf buf, int length, Calendar calParam) throws SQLDataException {
        Timestamp timestamp;
        if (length == 0) {
            return null;
        }
        Calendar cal = calParam == null ? Calendar.getInstance() : calParam;
        int year = buf.readUnsignedShort();
        byte month = buf.readByte();
        long dayOfMonth = buf.readByte();
        if (year == 0 && month == 0 && dayOfMonth == 0L) {
            return null;
        }
        Calendar calendar = cal;
        synchronized (calendar) {
            cal.clear();
            cal.set(year, month - 1, (int)dayOfMonth, 0, 0, 0);
            timestamp = new Timestamp(cal.getTimeInMillis());
        }
        timestamp.setNanos(0);
        return timestamp;
    }
}

